@echo off
title Tien ich sao luu dao v1.1
setlocal enabledelayedexpansion
set RCLONE_PATH=D:\rclone\rclone.exe
if exist %RCLONE_PATH% (
    echo rclone da co san, bo qua buoc tai ve.
) else (
    echo rclone chua co, dang tai ve...
    mkdir D:\rclone 2>nul
    curl -o D:\rclone\rclone.zip https://downloads.rclone.org/v1.69.1/rclone-v1.69.1-windows-amd64.zip
    echo Dang giai nen...
    powershell -Command "Expand-Archive -Path 'D:\rclone\rclone.zip' -DestinationPath 'D:\rclone' -Force"
    for /d %%D in ("D:\rclone\rclone-v1.69.1-windows-amd64") do move "%%D\rclone.exe" "D:\rclone"
    echo Don dep...
    del D:\rclone\rclone.zip
    rmdir /s /q D:\rclone\rclone-v1.69.1-windows-amd64
    echo Kiem tra phien ban rclone...
    %RCLONE_PATH% version
    if %ERRORLEVEL% NEQ 0 (
        echo Loi khi cai dat rclone. Kiem tra lai!
        pause
        exit /b
    )
)

:menu
mode con: lines=15
cls
echo =============================================================================
echo             UPLOAD - DOWNLOAD FILE / FOLDER FROM GOOGLE DRIVE
echo                            Minh Hai Computer
echo =============================================================================
echo    [1] Them cau hinh ket noi moi			     [Bam phim 1]
echo    [2] Xoa cau hinh ket noi				     [Bam phim 2]
echo    [3] Tai File / thu muc len Google Drive cua ban	     [Bam phim 3]
echo    [4] Tai File / thu muc tu  Google Drive cua ban	     [Bam phim 4]
echo    [5] Sao luu giua 2 tai khoan Google Drive cua ban         [Bam phim 5]
echo    [E] Thoat						     [Bam phim E]
echo =============================================================================
set /p "choice=Nhap lua chon (1-5, enter de quay lai): "
if "%choice%"=="" goto menu
if "%choice%"=="1" goto add_config
if "%choice%"=="2" goto xoa
if "%choice%"=="3" goto sync_data
if "%choice%"=="4" goto download_data
if "%choice%"=="5" goto backup_drive_to_drive
if "%choice%"=="e" exit
echo Lua chon khong hop le, vui long nhap lai!
pause
goto menu

:add_config
echo Nhap ten cau hinh moi (VD: drive1, drive2...):
set /p CONFIG_NAME=Nhap ten: 
if "%CONFIG_NAME%"=="" goto menu

echo Dang tao cau hinh...
echo. | %RCLONE_PATH% config create %CONFIG_NAME% drive scope drive
%RCLONE_PATH% config reconnect %CONFIG_NAME%:
echo Hoan tat ket noi!
pause
goto menu

:xoa
cls
echo =============================================================================
echo  		    XOA CAU HINH KET NOI TAI KHOAN GOOGLE DRIVE
echo =============================================================================

:: Kiem tra danh sach ket noi
set "INDEX=1"
for /f "delims=" %%i in ('%RCLONE_PATH% listremotes') do (
    set "CONFIG_LIST[!INDEX!]=%%i"
    echo [!INDEX!] %%i
    set /a INDEX+=1
)
if "%INDEX%"=="1" (
    echo  Khong co cau hinh nao de xoa!
    pause
    goto menu
)

:: Nhap so thu tu cau hinh can xoa
echo  Nhap so thu tu cau hinh can xoa (hoac go "0" de quay lai menu):
set /p CONFIG_INDEX=Nhap so: 
if "%CONFIG_INDEX%"=="0" goto menu
if "%CONFIG_INDEX%" LSS "1" goto xoa
if "%CONFIG_INDEX%" GEQ "%INDEX%" goto xoa

:: Lay ten cau hinh va xac nhan xoa
set "DELETE_NAME=!CONFIG_LIST[%CONFIG_INDEX%]!"
echo  Ban co chac chan muon xoa cau hinh "%DELETE_NAME%"? (Y/N)
set /p CONFIRM=Nhap lua chon: 
if /I "%CONFIRM%" NEQ "Y" (
    echo Huy xoa cau hinh!
    pause
    goto menu
)

:: Xoa cau hinh
echo Dang xoa cau hinh "%DELETE_NAME%"...
%RCLONE_PATH% config delete "%DELETE_NAME:~0,-1%" >nul 2>&1

:: Kiem tra lai danh sach ket noi
for /f "delims=" %%i in ('%RCLONE_PATH% listremotes') do (
    if /I "%%i"=="%DELETE_NAME%" (
        echo Loi: Xoa khong thanh cong! Cau hinh "%DELETE_NAME%" van ton tai.
        pause
        goto xoa
    )
)

echo Cau hinh "%DELETE_NAME%" da bi xoa thanh cong!
pause
goto menu



:sync_data
cls
echo =============================================================================
echo                TAI FILE / THU MUC LEN GOOGLE DRIVE CUA BAN
echo =============================================================================
echo   Danh sach ket noi hien co:
set "INDEX=1"
for /f "delims=" %%i in ('%RCLONE_PATH% listremotes') do (
    set "CONFIG_LIST[!INDEX!]=%%i"
    echo [!INDEX!] %%i
    set /a INDEX+=1
)
if "%INDEX%"=="1" (
    echo Khong co ket noi nao!
    pause
    goto menu
)
echo.
echo   Nhap so thu tu ket noi:
set /p CONFIG_INDEX=Nhap so: 
if "%CONFIG_INDEX%"=="" goto menu
if "%CONFIG_INDEX%" LSS "1" goto sync_data
if "%CONFIG_INDEX%" GEQ "%INDEX%" goto sync_data
set "CONFIG_NAME=!CONFIG_LIST[%CONFIG_INDEX%]!"
for /f "tokens=1 delims=:" %%a in ("%CONFIG_NAME%") do set "CONFIG_NAME_CLEAN=%%a"
echo Dang lay danh sach thu muc tu Google Drive...
del D:\rclone\drive_folders.txt 2>nul
%RCLONE_PATH% lsd "%CONFIG_NAME_CLEAN%:/" > D:\rclone\drive_folders.txt 2>&1
start notepad D:\rclone\drive_folders.txt
echo.
echo  Nhap ten thu muc muon tai len tren Google Drive:
set /p "REMOTE_PARENT=Nhap ten thu muc: "
if "%REMOTE_PARENT%"=="" (
    echo Ban chua nhap ten thu muc/file can tai len, quay ve menu chinh...
    pause
    goto menu
)
:sync_loop1
cls
echo =============================================================================
echo              TAI FILE / FOLDER LEN GOOGLE DRIVE CUA BAN
echo    [1] Lay danh sach duong dan File / thu muc trong o Dia	[Bam phim 1]
echo    [2] Tai File / thu muc len Google Drive			[Bam phim 2]
echo    [E] Quay lai menu chinh					[Bam phim 3]
echo =============================================================================
set /p "choice=Nhap lua chon: "
if "%choice%"=="1" goto list_folder
if "%choice%"=="2" goto sync_loop2
if "%choice%"=="3" goto menu
echo =============================================================================
:sync_loop2
echo  Thu muc chua file tai len cua ban tren Google Drive: %REMOTE_PARENT%
echo -----------------------------------------------------------------------------
:nhap_duong_dan
cls
echo  Thu muc chua file tai len cua ban tren Google Drive: %REMOTE_PARENT%
echo -----------------------------------------------------------------------------
echo Nhap duong dan thu muc/file can tai len (VD: D:\DuLieu) / nhan Enter de quay lai menu chinh:
set /p "LOCAL_FOLDER=Nhap duong dan: "
if "%LOCAL_FOLDER%"=="" goto menu
for %%I in ("%LOCAL_FOLDER%") do set "FOLDER_NAME=%%~nxI"
set "REMOTE_FOLDER=%CONFIG_NAME_CLEAN%:/%REMOTE_PARENT%/%FOLDER_NAME%"
echo  Dang dong bo thu muc/file "%LOCAL_FOLDER%" len "%REMOTE_FOLDER%"...
%RCLONE_PATH% sync "%LOCAL_FOLDER%" "%REMOTE_FOLDER%" Du lieu Google Drive
echo Tai file / thu muc len Google Drive cua ban thanh cong!
echo.
echo  Ban co muon tai them khong? (Y/N)
set /p "CONTINUE_CHOICE=Nhap lua chon: "
if /I "%CONTINUE_CHOICE%"=="Y" goto nhap_duong_dan
pause
goto menu

:download_data
cls
echo =============================================================================
echo             TAI FILE / FOLDER TU GOOGLE DRIVE CUA BAN VE MAY TINH
echo =============================================================================
echo Danh sach ket noi tai khoan Google Drive hien co:
set "INDEX=1"
for /f "delims=" %%i in ('%RCLONE_PATH% listremotes') do (
    set "CONFIG_LIST[!INDEX!]=%%i"
    echo [!INDEX!] %%i
    set /a INDEX+=1
)
if "%INDEX%"=="1" (
    echo Khong co ket noi nao!
    pause
    goto menu
)
echo.
echo Nhap so thu tu ket noi:
set /p CONFIG_INDEX=Nhap so: 
if "%CONFIG_INDEX%"=="" goto menu
if "%CONFIG_INDEX%" LSS "1" goto download_data
if "%CONFIG_INDEX%" GEQ "%INDEX%" goto download_data
set "CONFIG_NAME=!CONFIG_LIST[%CONFIG_INDEX%]!"
for /f "tokens=1 delims=:" %%a in ("%CONFIG_NAME%") do set "CONFIG_NAME_CLEAN=%%a"
echo Dang lay danh sach file va thu muc theo dang cay...
del D:\rclone\drive_tree.txt 2>nul
:: Lay danh sach thu muc va file theo dang cay
(for /f "delims=" %%F in ('%RCLONE_PATH% lsf --recursive "%CONFIG_NAME_CLEAN%:/"') do (
    set "ITEM=%%F"
    set "INDENT="
    set "FULL_PATH=%CONFIG_NAME_CLEAN%:/%%F"
    for /f "tokens=1-10 delims=/" %%A in ("%%F") do (
        if not "%%B"=="" set INDENT=    
        if not "%%C"=="" set INDENT=!INDENT!    
        if not "%%D"=="" set INDENT=!INDENT!    
        if not "%%E"=="" set INDENT=!INDENT!    
        if not "%%F"=="" set INDENT=!INDENT!    
        if not "%%G"=="" set INDENT=!INDENT!    
        if not "%%H"=="" set INDENT=!INDENT!    
        if not "%%I"=="" set INDENT=!INDENT!    
        if not "%%J"=="" set INDENT=!INDENT!    
    )
    echo !INDENT! [%%F] - !FULL_PATH!
)) > D:\rclone\drive_tree.txt
start notepad D:\rclone\drive_tree.txt
echo.
:download_loop
echo -----------------------------------------------------------------------------
echo  Nhap duong dan file hoac thu muc can tai xuong 
echo  (VD: MyFolder hoac MyFolder/myfile.txt):
set /p REMOTE_PATH=Nhap duong dan: 
if "%REMOTE_PATH%"=="" goto menu
echo Nhap duong dan thu muc luu tren may tinh (VD: D:\Downloads):
echo.
set /p LOCAL_FOLDER=Nhap duong dan: 
if "%LOCAL_FOLDER%"=="" goto menu
set "DEST_PATH=%CONFIG_NAME_CLEAN%:/%REMOTE_PATH%"
echo Dang tai "%DEST_PATH%" xuong "%LOCAL_FOLDER%"...
%RCLONE_PATH% copy "%DEST_PATH%" "%LOCAL_FOLDER%" Du lieu Google Drive
echo Tai xuong hoan tat!
echo Ban co muon tai them file/thu muc khac? (Y/N):
set /p CHOICE=
if /I "%CHOICE%"=="Y" goto download_loop
goto menu

:list_folder
cls
echo =============================================================================
echo                   LAY DANH SACH FILE VA THU MUC TU O DIA
echo =============================================================================
echo Nhap ky tu o dia (VD: D, E, F):
set /p "DRIVE_LETTER=Nhap o dia va cho mot chut: "
echo Danh sach file dang duoc tao
if "%DRIVE_LETTER%"=="" goto sync_menu
if not exist "%DRIVE_LETTER%:\" (
    echo O dia khong ton tai! Vui long nhap lai.
    pause
    goto list_files
)

:: Tao danh sach thu muc & file
set "OUTPUT_FILE=%TEMP%\file_list.txt"
del "%OUTPUT_FILE%" 2>nul
echo Danh sach file va thu muc trong %DRIVE_LETTER%:\ > "%OUTPUT_FILE%"
for /r "%DRIVE_LETTER%:\" %%i in (*) do echo %%i >> "%OUTPUT_FILE%"
start notepad "%OUTPUT_FILE%"

goto sync_loop1



:backup_drive_to_drive
mode con: lines=40
cls
echo =============================================================================
echo               SAO LUU THU MUC GIUA 2 TAI KHOAN GOOGLE DRIVE
echo =============================================================================

echo Danh sach cac cau hinh:
%RCLONE_PATH% listremotes > remotes.txt
set /a index=0
for /f "delims=:" %%a in (remotes.txt) do (
    set /a index+=1
    echo [!index!] %%a
    set "remote[!index!]=%%a"
)
del remotes.txt

:chonsrc
set /p SRC_INDEX=Nhap so thu tu cua remote nguon: 
if not defined remote[%SRC_INDEX%] (
    echo Lua chon khong hop le. Vui long nhap lai!
    goto chonsrc
)
set SRC_REMOTE=!remote[%SRC_INDEX%]!:

echo Dang lay danh sach thu muc...
%RCLONE_PATH% lsd %SRC_REMOTE%
if %ERRORLEVEL% NEQ 0 (
    echo Loi khi lay danh sach thu muc. Kiem tra lai!
    pause
    goto menu
)
echo Nhap duong dan thu muc can sao luu:
set /p SRC_FOLDER=

:chondst
set /p DEST_INDEX=Nhap so thu tu cua remote dich: 
if not defined remote[%DEST_INDEX%] (
    echo Lua chon khong hop le. Vui long nhap lai!
    goto chondst
)
set DEST_REMOTE=!remote[%DEST_INDEX%]!:

echo Dang lay danh sach thu muc dich...
%RCLONE_PATH% lsd %DEST_REMOTE%
echo Nhap duong dan thu muc dich:
set /p DEST_FOLDER=

echo %SRC_REMOTE%%SRC_FOLDER% > backup_paths.txt
echo %DEST_REMOTE%%DEST_FOLDER% >> backup_paths.txt

echo Duong dan thu muc da duoc luu vao backup_paths.txt.
echo Kiem tra duong dan truoc khi tien hanh sao luu:
echo Nguon: %SRC_REMOTE%%SRC_FOLDER%
echo Dich: %DEST_REMOTE%%DEST_FOLDER%
pause
%RCLONE_PATH% copy "%SRC_REMOTE%%SRC_FOLDER%" "%DEST_REMOTE%%DEST_FOLDER%" Du lieu Google Drive --transfers=16
if %ERRORLEVEL% NEQ 0 (
    echo Loi khi sao luu! Kiem tra duong dan hoac ket noi.
) else (
    echo Sao luu hoan tat!
)
pause
goto menu